// Split from main file 23/11/2023

use "${EHIS}\EHIS wave 3\0_w2w3combined ${versno}.dta", replace
/*	CAN USE FREQEUENCY WEIGHTS if want to weight according to survey size
	gen fwgt = round(wgt,1)
	* CHECKING HOW THINGS HAVE CHANGED IN SWEDEN
	prop hs3 if country=="SE" [fw=fwgt], over(wave)
	prop hs1 if country=="SE" [fw=fwgt], over(wave)
*/
// IRT model doesn't converge without getting rid of this very small group
recode PHQgroup (5 4=4)
label define PHQgroup 4"4_Severe depression", modify

// Disability weights (which drops item-missing cases) - on EHIS on 3rd Aug 2023, takes 4mins
	global agerange			"inrange(age,3,12)"		
	global countrywaves		`"!inlist(country,"BE","FI","NL")"'		// countries that are missing one wave -see also data cleaning where countries with incomparable methods are dropped
	global whichversions	"IRT L allIRT H predfxd H"
	global allIRTbinary		= subinstr("${allIRTbinary}", "cd1pR "    , "", .)		// not available for EHIS w2
do "${dodir}\4_dis_weights.do"
	estimates clear
	estpost tab country		// Sample size for each country-wave in this run (there's an alternative under 'Alternatives')
		esttab using "${dodir}\Outputs\n_samplesizes.rtf", replace cells("b(label(freq))") varlabels(, blist(Total "{hline @width}{break}")) nonumber nomtitle noobs varwidth(25)
save "${EHIS}\EHIS wave 3\0_w2w3combined ${versno}_withdisweights.dta", replace



****************************************************************************************************************************************
* To run before any of the results below, even if being run separately
****************************************************************************************************************************************

do "${dodir}\0_globals.do"				
use "${EHIS}\EHIS wave 3\0_w2w3combined ${versno}_withdisweights.dta", replace
matrix drop _all
* Run every time
global controlsmeans ""		// Calculating mean of controls2 variables
	capture svy: mean ${controls} ${controls2}
	if _rc==0	{							// ${controlsmeans} should be empty where ${controls2} is empty
		foreach word in `e(varlist)'	{
			local col = `col' + 1
			local working = e(b)[1, `col']
			global controlsmeans "${controlsmeans} `word'=`working'"
		/**/							}
	/**/		}
dis in red "Controls are ${controls} ${controls2} - their means in the atspec are ${controlsmeans"}
pause Check this is correct!
* Load the command
do "${dodir}\7_EHIStrend_bootstrap.do"	


// Checks
tab country modeflag, m
tab country wave, m


****************************************************************************************************************************************
* Non-bootstrapped results (excludes PPWD and has one-off version of pred_random)
****************************************************************************************************************************************

* Load everything just above			
* Then just run the results file
do "${dodir}\7_EHIStrend_nonbootstrap.do"				


	
****************************************************************************************************************************************
* Bootstrapped results
****************************************************************************************************************************************

* Load everything just above			

* Test bootstrap - note that delete the controls2 option when this is empty
	/**/ 	disempBS_trend ${countryvar} /*${if}*/, wavevar(wave) distypes("dis predicted") controls(${controls}) controls2(${controls2})	/// fixedpred irt allirt
	/**/ 	empvar(${empvar}) disvar(${disvar}) irtvar(${IRTvar}) allirtvar(${allIRTvar}) fixedpredvar(${predictedvar}_fxd) predictedvar(${predictedvar}) 

// Bootstrapped results when test bootstrap works
global run = 				7						// '7' is for EHIStrend
global reps					"400"				 	// replications for bootstrapping, both BOOTSTRAP & SVY BOOTSTRAP
* The actual bootstrap command - for error-checking, add 'noisily' back in
eststo bootstrap_all: bootstrap, nodrop reps(${reps}) seed(13062017) saving("${dodir}\Outputs\bsEHIS_run${run}.dta", replace) strata($countryvar) /*noisily*/ /// 	
	/**/ :  disempBS_trend ${countryvar} /*${if}*/, wavevar(wave) distypes("dis predicted") controls(${controls}) controls2(${controls2})		/// fixedpred irt allirt
	/**/ 	empvar(${empvar}) disvar(${disvar}) irtvar(${IRTvar}) allirtvar(${allIRTvar}) fixedpredvar(${predictedvar}_fxd) predictedvar(${predictedvar}) 
estat bootstrap, bc				
* Outputting the results
esttab bootstrap_all using "${dodir}\outputs\2_bsEHIS_run${run}.csv", csv replace not ci nostar nonum nodepvars b(%5.4f) /// 	
	cells("b ci_normal[ll] ci_percentile[ll] ci_bc[ll]" "bias ci_normal[ul] ci_percentile[ul] ci_bc[ul]")					///
	addnotes("Col 2 is normal-based CI, col3 is percentile-based CI, col4 is bias-corrected CI" 							///
			 "Number of replications is ${reps}, date outputted is `c(current_date)', subgroup is "${if}"")

			 
/* Checking strange changes in prevalence of disability
use "${EHIS}\EHIS wave 3\0_w3cleaned ${versno}.dta", replace
	recode hs1 (-3.=.p) (-1=.r)
	svy: prop llsiB severellsiB hs1 if country=="LT" 
use "${EHIS}\EHIS wave 2\0_w2cleaned ${versno}.dta", replace
	recode hs1 (-3.=.p) (-1=.r)
	svy: prop llsiB severellsiB hs1 if country=="LT"
*/